//
//  BMKBaseUIView.h
//  MapComponent
//
//  Created by zhaoxiangru on 2024/3/12.
//  Copyright © 2024 Baidu. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
/**
 *  This view is visible.
 *  Use with {@link # setVisibility}.
 */
typedef enum : NSUInteger {
    BMKVisibilityVisible     =  (0x1 << 0),  // 可见
    BMKVisibilityInvisible   =  (0x1 << 1),  // 不可见，但占用空间区域 (暂不支持)
    BMKVisibilityGone        =  (0x1 << 2),  // 不可见，也不占用空间区域
} BMKVisibility;

/**
 *  可绘制内容位于控件的位置；控件内部的布局。
 */
typedef enum : NSUInteger {
    BMKGravityLeft             = (0x1 << 0),     /** Push object to the left of its container, not changing its size. */
    BMKGravityTop              = (0x1 << 1),     /** Push object to the top of its container, not changing its size. */
    BMKGravityRight            = (0x1 << 2),     /** Push object to the right of its container, not changing its size. */
    BMKGravityBottom           = (0x1 << 3),     /** Push object to the bottom of its container, not changing its size. */
    BMKGravityCenterHorizontal = (0x1 << 4),     /** Place object in the horizontal center of its container, not changing its size. */
    BMKGravityCenterVertical   = (0x1 << 5),     /** Place object in the vertical center of its container, not changing its size. */
    BMKGravityCenter           = (BMKGravityCenterHorizontal | BMKGravityCenterVertical),
    BMKGravityBottomHCenter    = (BMKGravityBottom | BMKGravityCenterHorizontal),
} BMKGravityType;

@interface BMKBaseUIView : NSObject
@property (nonatomic, assign) BMKVisibility   visibility; /** 控件可见的状态 */
// 设置UI宽高，不设置按内容自适应（按图片或字体）；label也可以只设置width，代表按这个最大宽度适配多行文字，最多20行
@property (nonatomic, assign) int width;
@property (nonatomic, assign) int height;
// 一个基本条件：只有父容器的宽高大于内部控件宽高，才能体现出gravity 居左 局右 局上 局下，否则父容器默认是自适应的，是子控件把容器充满的，就体现不出gravity
// VerticalLayout默认是左上，只能对一个UI的底部对齐有效；只能对一个UI的垂直居中有效；对多个UI局右可以生效（即靠右对齐），多个UI局中垂直可以生效（即水平中线对齐）
// HorizontalLayout默认是左上，只能对一个UI的局右有效；只能对一个UI的水平局中有效；多个UI局下有效（即水平底部对齐），多个UI水平局中有效（即整体布局垂直中线对齐）
@property (nonatomic, assign) BMKGravityType gravity;     /** 控件内部的布局 */
@property (nonatomic, assign) UIEdgeInsets padding;         /** 控件内部的空白区 */
@property (nonatomic, assign) UIEdgeInsets margin;          /** 控件外部的空白区 */
@property (nonatomic, assign) BOOL clickable;               /** @Defalt false */

// 背景图片，防止图片变形使用-setBackgroundImage：capInsets：设置背景图片
@property (nonatomic, strong) UIImage *background;
// 背景图片混合颜色，需要配合背景图片使用，单独设置无效；配合白色或部分透明背景图片使用，可以实现背景颜色自定义或圆角效果
@property (nonatomic, strong) UIColor *backgroundColor;

/// 设置背景图片
/// @param image 背景图片
/// @param capInsets 可缩放区域
- (void)setBackgroundImage:(UIImage *)image capInsets:(UIEdgeInsets)capInsets;

/// 点击事件，the action cannot be NULL. Note that the target is not retained.
- (void)setTarget:(nullable id)target action:(SEL)clickAction;
@end

NS_ASSUME_NONNULL_END
