//
//  BMKBackgroundRoadNetView.h
//  MapComponent
//
//  Created by zhaoxiangru on 2024/2/29.
//  Copyright © 2024 Baidu. All rights reserved.
//

#import <QuartzCore/QuartzCore.h>
#import "BMKMapStatus.h"
@class BMKMapView;
NS_ASSUME_NONNULL_BEGIN

@interface BMKBackgroundRoadNetView : UIView
/// 关联源地图，用于同步数据
@property (nonatomic, weak, nullable) BMKMapView *mapview;
/// 设置路网背景颜色
//@property (nonatomic, strong) UIColor *roadNetBackColor;
/// 设置路网颜色
@property (nonatomic, strong) UIColor *roadNetColor;

/// 渲染路网
- (void)renderWithMapStatus:(BMKMapStatus *)mapstatus enable3D:(BOOL)enable3D fitScale:(CGFloat)fitScale mapScreenExtOffset:(CGPoint)mapScreenExtOffset;
@end

NS_ASSUME_NONNULL_END
